
markup.push
({

// -------------------------------------------------
// MARK: recorder block

AudioRecorderBlock:
{
	"+": "OutputTemplate",
	geNodeClass: "GEAudioRecorderNode",
	gxFaceModel: {
		nsClass: "H4RecorderBlockFace",
		gxFaceModelKeyPath: "faceModel",
	},
    h4PresetsId: "RecorderPresets4",
	geOutputRank: 3,  // output rank of importance. Nothing else should have same rank as recorder
	geOutputVerb: "Recording",
	recorderBlock: true,		// flag for code to identify block type easily
	gxTitle: "Recorder",
	gxPopoverInfo: "RecorderPopover",
	gxLibraryDescription: "Record audio to files",
	gxLibraryIcon: "library.recorder",
	gxDescriptionKeyPath: "node.briefFormatDescription",
	gxNodeInitialProperties: { "formatPreset": "MP3_256" },
	gxChildViews:
	{
		spinnerHost:
		{
			nsClass: "GXLayerHostingView",
			gxFrameRect: "12,48,23,23",
			gxRootLayer:
			{
				nsClass: "GXCaarLayer",
				gxViewName: "spinner",
				gxValueKey: "node.spinnerValue",
				gxStylesKeyPath: "node.spinnerStyles",
				gxAnimateOnKey: "node.isRecording",
				gxShowOnKey: "node.isRecording",
				gxAnimationDivider: 2,
				gxCaarPainter: "RecordingSpinnerPainter.blockFace",
				gxTransition: {
					nsClass: "GXSpinnerTransition",
					gxDuration: 1.0,
					gxRunOn: 1.0,
				},
			}
		},
		time: {
			"+": "LabelView.blockReadout.top.left.boldWeight.size15",
			gxFormatter: { nsClass:"PTTrackTimeFormatter" },
			gxFrameRect: "38,41,80,22",
			gxValueKey: "node.blockTimeValue",
			gxAnimateOnKey: "node.isRecording",
			gxHideOnNilValue: true,
			axIsIgnored: false,
			axTitle: "Recording Duration",
		},
		size: {
			"+": "LabelView.blockReadout.top.left",
			gxFormatter: { nsClass:"PTFileSizeFormatter" },
			gxFrameRect: "39,62,80,22",
			gxValueKey: "node.blockSizeValue",
			gxAnimateOnKey: "node.isRecording",
			gxHideOnNilValue: true,
			axIsIgnored: false,
			axTitle: "File Size",
		},
		stopped: {
			"+": "LabelView.blockReadout.size13",
			gxFrameRect: "12,49,96,22",
			gxValueKey: "node.stoppedDisplay",
			gxHideOnNilValue: true,
		},
		format: {
			"+": "LabelView.foreColorTheme1.top.boldWeight.size15",
			gxFrameRect: "15,41,90,22",
			gxValueKey: "node.formatNameForDisplay",
			gxToolTipKeyPath: "node.format.briefDisplayDescription",
			gxHideOnNilValue: true,
			axIsIgnored: false,
			axTitle: "recording format",
			axValueKeyPath: "node.format.briefDisplayDescription",
		},
		details: {
			"+": "LabelView.foreColorTheme1.top.size11",
			gxFrameRect: "10,62,98,22",
			gxValueKey: "node.formatDetailsForDisplay",
			gxHideOnNilValue: true,
			axIsIgnored: true,
			axDescription: "format details",
		},
		pause: {
			"+": "BlockButton",
			gxTitle: "Pause",
			gxValueKey: "node.pauseButtonValue",
			gxDisplayValueKey: "node.pauseButtonShortTitle",
			gxFrameRect: "14,86,44,18",
            gxButtonType: "toggle",
		},
		split: {
			"+": "BlockButton",
			gxTitle: "Split",
			gxValueKey: "node.splitButtonValue",
			gxFrameRect: "62,86,44,18",
		}
	}
},


// -------------------------------------------------
// MARK: recorder popover

RecorderPopover:
{
	"+": "PopoverTemplate",
 	//gxViewModel: { nsClass: "AH4RecorderViewModel" },
	gxTitle: "Recorder",
	gxLayout:
	[
		"H:|-12-[self(420)]-12-|",
		"V:|-12-[self]-12-|",

		"V:|-43-[statusHolder(27)]-9-[pause]-9-[panelsBtn]-0-[panels]-0-[bottomDivider]-8-[presetsGroup]",

		"H:|-12-[pause]-12-[split(==pause)]-12-|&alignBaseline",
	],
	gxChildViews:
	{
		title: "PopoverTitle",
		onOff: "PopoverOnOffSwitch",
		presetsGroup: presetsGroup(),
		statusHolder: { "+": "RecorderStatus" },
		pause: {
			"+": "RecorderPauseSplitButton",
			gxTitle: "Pause Recording",
			gxValueKey: "node.pauseButtonValue",
			gxDisplayValueKey: "node.pauseButtonLongTitle",
		},
		split: {
			"+": "RecorderPauseSplitButton",
			gxTitle: "Split File",
			gxValueKey: "node.splitButtonValue",
		},
		panelsBtn: {
			"+": "AdvancedGroupButton",
			gxTitle: "<disclosure/> Recording Options",
			axFormatter: disclosureAxFormatter("Recording Options"),
			axHelp: "Reveals this recorder block's configuration options when expanded",
			gxValueKey: "node.panelsExpanded",
		},
		panels:
		{
			nsClass: "GXExpandingView",
			axIsIgnored: true,
 			gxDefaultValue: true,	// expanded
			gxValueKey: "node.panelsExpanded",
			gxLayout:
			[
				 "H:|-1-[self]-1-|",
				 "V:|-6-[tabHolder(24)]",
				 "V:|-17-[tabDivider]",
				 "V:|-11-[generalPanel]",
				 "V:|-11-[tagsPanel]",
				 "V:|-11-[advancedPanel]"
			],
			gxChildViews:
			{
				tabHolder: { "+": "RecorderTabs" },
				tabDivider: dividerView(),
				generalPanel: { "+": "GeneralPanel" },
				advancedPanel: { "+": "AdvancedPanel" },
				tagsPanel: { "+": "TagsPanel" },
			}
		},
		bottomDivider: dividerView(),
	}
},
    

// -------------------------------------------------
// MARK: status group

RecorderStatus:
{
	nsClass: "GXDrawView",
	axIsIgnored: false,
	axTitle: "Current Recording Status",
	gxForePainter: {
		nsClass: "GXPainter",
		gxFillColor: "ColorThemeLive1.alphaBg",
		gxEdgeInsets: "12, 0, 12, 0",
		gxCornerRadius: 999,
	},
	gxLayout:
	[
		"H:|-0-[self]-0-|",
	 
		"H:|-18-[spinnerHost(21)]-4-[status]-8-[loupe(16)]-8-[size(60)]-8-[duration(50)]-24-|",
		"H:|-21-[checkmark(12)]",
	 
		"V:|-3-[spinnerHost(21)]",
		"V:|-8-[checkmark(12)]",
		"V:|-5-[status]",
		"V:|-5-[size]",
		"V:|-5-[duration]",
		"V:|-6-[loupe(18)]",
	],
	gxChildViews:
	{
		spinnerHost:
		{
			nsClass: "GXLayerHostingView",
			gxRootLayer:
			{
				nsClass: "GXCaarLayer",
				gxViewName: "spinner",
				gxValueKey: "node.spinnerValue",
				gxStylesKeyPath: "node.spinnerStyles",
				gxAnimateOnKey: "node.isRecording",
				gxHideOnNilValue: true,
				gxAnimationDivider: 2,
				gxCaarPainter: "RecordingSpinnerPainter",
				gxTransition: {
					nsClass: "GXSpinnerTransition",
					gxDuration: 1.0,
					gxRunOn: 1.0,
				},
			}
		},
		checkmark: {
			nsClass: "GXDrawView",
			gxBackPainter: "ImagePainter.colorTheme1.checkmark",
			gxShowOnKey: "node.showCheckmark",
		},
		status: {
			"+": "LabelView.useMarkup.top.left.boldWeight.colorThemeLive1.size13",
			gxValueKey: "node.statusDisplay",
			gxHideOnNilValue: true,
			axIsIgnored: false,
			axTitle: "Status",
		},
		loupe: {
			"+": "ImageButtonView.colorThemeLive1.loupe",
			gxValueKey: "node.statusLoupeBtn",
			gxHideOnNilValue: true,
			axIsIgnored: true,	// not much use to AX user yet?
			axTitle: "Reveal Recording File",
		},
		size:
		{
			"+": "LabelView.top.right.colorThemeLive1.size13",
			gxValueKey: "node.statusSizeValue",
			gxAnimateOnKey: "node.isRecording",
			gxHideOnNilValue: true,
			gxFormatter: { nsClass:"PTFileSizeFormatter" },
			axIsIgnored: false,
			axTitle: "File Size",
		},
		duration:
		{
			"+": "LabelView.top.right.colorThemeLive1.size13",
			gxValueKey: "node.statusTimeValue",
			gxAnimateOnKey: "node.isRecording",
			gxHideOnNilValue: true,
			gxFormatter: { nsClass: "PTTrackTimeFormatter" },
			axIsIgnored: false,
			axTitle: "Duration",
		},
	}
},

	
// -------------------------------------------------
// MARK: tabs group

RecorderTabs:
{
	nsClass: "GXDrawView",
	//axIsIgnored: false,
	//axTitle: "Tab Group",
	gxLayerZPosition: 10,
	gxLayout:
	[
		"H:|-0-[self]-0-|",
		"H:|-52-[generalTab]-(1)-[tagsTab(==generalTab)]-(1)-[advancedTab(==generalTab)]-52-|&alignBaseline",
	],
	gxChildViews:
	{
		generalTab: {
			"+": "TabButtonView.leftSegment",
			gxTitle: "General",
			gxValueKey: "node.generalTabBtn",
			axRoleDescription: "Tab, 1 of 3"
		},
		tagsTab: {
			"+": "TabButtonView.middleSegment",
			gxTitle: "Tags",
			gxValueKey: "node.tagsTabBtn",
			axRoleDescription: "Tab, 2 of 3"
		},
		advancedTab: {
			"+": "TabButtonView.rightSegment",
			gxTitle: "File Limits",
			gxValueKey: "node.advancedTabBtn",
			axRoleDescription: "Tab, 3 of 3"
		},
	},
},
	
	
// -------------------------------------------------
// MARK: general panel

GeneralPanel:
{
	nsClass: "GXExpandingView",
	axIsIgnored: false,
	axTitle: "General Group",
	axFrameInsets: "0, 25, 0, 0",	// avoid overlaps with tabs so nav order is improved
	gxShowOnKey: "node.generalTabBtn",
	gxDefaultValue: true,	// expanded
	gxLayout:
	[
		"H:|[self]|",
		"H:|-85-[name]",
		"H:[nameLabel]-[name]-12-|&alignBaseline",

		"H:[directoryLabel]-[directory]&alignBaseline",
		"H:[directory]-[loupe(20)]-10-|",
		"V:[directory]-(-21)-[loupe(20)]",

		"V:|-32-[name]-10-[directory]-10-[presetFormat]-7-[description]&alignLeft",

		"H:[presetFormatLabel]-[presetFormat]-12-|&alignBaseline",
		"H:[description]-38-|",

		"V:[description]-7-[advancedBtn]-0-[advancedSection]",
	],
	gxChildViews:
	{
		name: {
			"+": "RecorderTokenField",
			gxValueKey: "node.fileName",
			gxLabelText: "File name:"
		},
		directory: {
			"+": "PopupMenuTemplate",
			gxMenuItemsKeyPath: "node.folderMenuItems",
			gxValueKey: "node.folderMenuSelectedPath",
			gxDisableOnKey: "running",
			gxLabelText: "Save to:"
		},
		loupe: {
			"+": "ImageButtonView.loupe",
			gxValueKey: "node.folderLoupeBtn",
			axTitle: "Folder Reveal"
		},
		presetFormat: {
			"+": "PresetFormatPopupMenu",
			gxLabelText: "Quality:"
		},
		description: {
			"+": "LabelView.left.darkest.size12",
			gxValueKey: "node.formatDescription",
			gxIntrinsicWidth: -1,
		},
		advancedBtn: {
			"+": "AdvancedGroupButton.noTopStroke",
			gxTitle: "     <disclosure/> Advanced Quality Options",
			axFormatter: disclosureAxFormatter("Advanced Quality Options"),
			gxValueKey: "node.formatOptionsExpanded",
		},
		advancedSection:
		{
			nsClass: "GXStackView",
			gxValueKey: "node.formatOptionsExpanded",
			gxDefaultValue: false, // collapsed
			gxExtraSize: 8,
			//axIsIgnored: false,
			//axTitle: "Advanced Format Options",
			gxLayout: "H:|-16-[self]-0-|",
			gxChildViews:
			[
				// format type
				{
					nsClass: "GXDrawView",
					gxHideOnNilValue: true,
					gxViewName: "formatType",
					gxLayout: [
						"H:|-0-[self]-0-|",
						"V:|-(-999)-[self(37)]",	// vertical position set by parent
					],
					gxChildViews:
					{
						formatType: {
							"+": "RecorderPopupMenu",
							gxLayout: [ "H:[selfLabel]-[self]&alignBaseline",
										"H:|-85-[self]-12-|",
										"V:|-7-[self]" ],
							gxMenuItemsKeyPath: "node.formatTypeMenuItems",
							gxDisableOnKey: "running",
							gxLabelText: "Format:"
						}
					}
				},
				enclosureView(
					"bitsPerSample",
					{
						"+": "RecorderPopupMenu",
						gxMenuItemsKeyPath: "node.bitsPerSampleMenuItems",
						gxDisableOnKey: "running",
						gxLabelText: "Type:"
					}
				),
				enclosureView(
					"bitrate",
					{
						"+": "RecorderPopupMenu",
						gxMenuItemsKeyPath: "node.bitrateMenuItems",
						gxDisableOnKey: "running",
						gxLabelText: "Bit Rate:"
					}
				),
				enclosureView(
					"bitrateMode",
					{
						"+": "RecorderPopupMenu",
						gxMenuItemsKeyPath: "node.bitrateModeMenuItems",
						gxDisableOnKey: "running",
						gxLabelText: "Bit Rate Mode:"
					}
				),
				enclosureView(
					"samplerate",
					{
						"+": "RecorderPopupMenu",
						gxMenuItemsKeyPath: "node.sampleRateMenuItems",
						gxDisableOnKey: "running",
						gxLabelText: "Sample Rate:"
					}
				),
				enclosureView(
					"channels",
					{
						"+": "RecorderPopupMenu",
						gxMenuItemsKeyPath: "node.channelsMenuItems",
						gxDisableOnKey: "running",
						gxLabelText: "Channels:"
					}
				),
				// m4a vs mp4 file format
				enclosureView(
					"fragmented",
					{
						"+": "RecorderPopupMenu",
						gxMenuItems:
						[
							{ gxTitle: ".mp4 (Safer recording)", gxValue: 1 },
							{ gxTitle: ".m4a (More compatible)", gxValue: 0 },
						],
						gxDisableOnKey: "running",
						gxLabelText: "Container:"
					}
				),
				// he aac checkbox
				enclosureView(
					"heAAC",
					{
						"+": "CheckboxTemplate",
						//gxValueKey: "node.HEAACEnabled",
						//gxDisableOnKey: "disableHeAACCheckBox",
						gxHideOnNilValue: true,
						gxTitle: "<checkbox/> Use High Efficiency (HE-AAC)",
						gxLayout: [ "H:|-129-[self(218)]",
									"V:|-5-[self]" ]
					}
				),
				// dithering mode
				enclosureView(
					"dithering",
				   {
					   "+": "RecorderPopupMenu",
					  gxMenuItemsKeyPath: "node.ditheringModeMenuItems",
					  gxDisableOnKey: "running",
					  gxLabelText: "Dithering:"
				   }
				),
			]
		}
	}
},

	
// -------------------------------------------------
// MARK: tags panel

TagsPanel:
{
	nsClass: "GXDrawView",
	axIsIgnored: false,
	axTitle: "File Tags Group",
	axFrameInsets: "0, 25, 0, 0",	// avoid overlaps with tabs so nav order is improved
	gxShowOnKey: "node.tagsTabBtn",
	gxLayout:
	[
		"H:|[self]|",

		"V:|-32-[title]-9-[artist]-9-[album]-9-[track]-9-[disc]&alignLeft",

		"H:[titleLabel]-8-[title]-13-|&alignBaseline",
		"H:|-20-[artistLabel]-8-[artist]-13-|&alignBaseline",
		"H:|-11-[albumLabel]-8-[album]-13-|&alignBaseline",

		"H:[trackLabel]-8-[track(34)]-8-[trackCountLabel]-8-[trackCount(34)]-(>=8)-[yearLabel]-8-[year(44)]-14-[compilation(105)]&alignBaseline",
		//"H:[yearLabel]-[year(44)]-13-[compilation(105)]&alignBaseline",
		"H:[discLabel]-8-[disc(34)]-8-[discCountLabel]-8-[discCount(34)]-8-[genreLabel]-8-[genre]-13-|&alignBaseline",

		"V:[year]-(>=0)-[genre]&alignLeft",

		"V:[disc]-9-[comment]-14-|",
		"V:[disc]-9-[albumArt(95)]-14-|",

		"H:|-18-[comment]-9-[albumArt(95)]-13-|",
	],
	gxChildViews: {
		title: {
			"+": "RecorderTokenField",
			gxValueKey: "node.tags.title",
			gxExcludeToken: "%tag_title",
			gxLabelText: "Title:",
			axTitle: "Title",
		},
		artist: {
			"+": "RecorderTokenField",
			gxValueKey: "node.tags.artist",
			gxExcludeToken: "%tag_artist",
			gxLabelText: "Artist:",
			axTitle: "Artist",
		},
		comment: {
			"+": "RecorderTokenField.multiline",
			gxValueKey: "node.tags.comment",
			gxExcludeToken: "%tag_comment",
			gxPlaceholderString: "Comments",
			axTitle: "Comments",
		},
		albumArt: {
			"+": "ArtView",
			gxDisableOnKey: "running",
			gxValueKey: "node.tags.albumArt",
			axTitle: "Album Art",
			axHelp: "Paste an image here to use as album artwork",
		},
		album: {
			"+": "RecorderTokenField",
			gxValueKey: "node.tags.album",
			gxExcludeToken: "%tag_album",
			gxLabelText: "Album:",
			axTitle: "Album",
		},
		year: {
			"+": "DarkNumberField",
			gxRangeMax: 9999,
			gxValueKey: "node.tags.year",
			gxDisableOnKey: "running",
			gxLabelText: "Year:",
			axTitle: "Year",
		},
		track: {
			"+": "DarkNumberField",
			gxValueKey: "node.tags.track",
			gxDisableOnKey: "running",
			gxLabelText: "Track:",
			axTitle: "Track number",
		},
		trackCount: {
			"+": "DarkNumberField",
			gxValueKey: "node.tags.trackCount",
			gxDisableOnKey: "running",
			gxLabelText: "of:",
			axTitle: "Track Count"
		},
		genreLabel: labelView("Genre:"),
		genre: {
			"+": "GenrePopupMenu",
			gxValueKey: "node.tags.genre",
			gxDisableOnKey: "running",
			axTitle: "Genre",
		},
		disc: {
			"+": "DarkNumberField",
			gxValueKey: "node.tags.disc",
			gxDisableOnKey: "running",
			gxLabelText: "Disc:",
			axTitle: "Disc Number",
		},
		discCount: {
			"+": "DarkNumberField",
			gxValueKey: "node.tags.discCount",
			gxDisableOnKey: "running",
			gxLabelText: "of:",
			axTitle: "Disc Count",
		},
		compilation: {
			"+": "CheckboxTemplate",
			gxValueKey: "node.tags.partOfCompilation",
			gxDisableOnKey: "running",
			gxDisableOnNil: false,
			gxTitle: "<checkbox/> Compilation"
		}
	}
},
	
	
// MARK: advanced panel

AdvancedPanel:
{
	nsClass: "GXDrawView",
	axIsIgnored: false,
	axTitle: "File Limits Group",
	axFrameInsets: "0, 25, 0, 0",	// avoid overlaps with tabs so nav order is improved
	gxShowOnKey: "node.advancedTabBtn",
	gxLayout:
	[
		"H:|[self]|",
		"H:|-15-[splitterCheck(153)]-3-[splitterValue(42)]-8-[splitterMenu]-70-|&alignBaseline",
		"H:|-15-[stopperCheck(153)]-3-[stopperValue(42)]-8-[stopperMenu]-70-|&alignBaseline",
		"H:|-15-[silenceCheck(25)]-1-[silenceMenu(126)]-(>=10)-[silenceMenuLabel]-8-[silenceTime(42)]-5-[silenceTimeLabel]&alignBaseline",
		"H:[silenceThresholdLabel]-9-[silenceThreshold]-8-[silenceReadout(40)]-10-|&alignBaseline",
		
		"V:[stopperValue]-(>=0)-[silenceThreshold]&alignLeft",
		"V:[stopperMenu]-(>=0)-[silenceTime]&alignLeft",
		
		"V:[silenceThresholdLabel(18)]",
		
		// vertical height adjusted to match general panel (when advanced section collapsed)
		"V:|-32-[splitterCheck]-14-[stopperCheck]-14-[silenceCheck]-6-[silenceThreshold(41)]-14-|"
	],
	gxChildViews:
	{
		splitterCheck: {
			"+": "CheckboxTemplate",
			gxTitle: "<checkbox/> Start new file every:",
			gxValueKey: "node.splitter.enabled",
			gxDisableOnKey: "running",
			axHelp: "Splits files automatically at a size or duration"
		},
		splitterValue: {
			"+": "DarkNumberField",
			gxNilWhenEmpty: false,
			gxRangeMax: 99999,	// model will limit
			gxValueKey: "node.splitter.size",
			gxDisableOnKey: "node.splitterEditingDisabled",
			axTitle: "Split file value"
		},
		splitterMenu: {
			"+": "TimeOrSpacePopupMenu",
			gxValueKey: "node.splitter.unitsKey",
			gxDisableOnKey: "node.splitterEditingDisabled",
			axTitle: "Split file units"
		},
		stopperCheck: {
			"+": "CheckboxTemplate",
			gxTitle: "<checkbox/> End recording after:",
			gxValueKey: "node.stopper.enabled",
			gxDisableOnKey: "running",
			axHelp: "Stops recording automatically after a size or duration"
		},
		stopperValue: {
			"+": "DarkNumberField",
			gxNilWhenEmpty: false,
			gxRangeMax: 99999,	// model will limit
			gxValueKey: "node.stopper.size",
			gxDisableOnKey: "node.stopperEditingDisabled",
			axTitle: "Stop recording value",
		},
		stopperMenu: {
			"+": "TimeOrSpacePopupMenu",
			gxValueKey: "node.stopper.unitsKey",
			gxDisableOnKey: "node.stopperEditingDisabled",
			axTitle: "Stop recording units",
		},
		silenceCheck: {
			"+": "CheckboxTemplate",
			gxTitle: "<checkbox/> ",
			gxValueKey: "node.silenceKiller.enabled",
			gxDisableOnKey: "running",
			axTitle: "Silence Monitor",
			axHelp: "Perform an automatic action on silence",
		},
		silenceMenu: {
			"+": "PopupMenuTemplate",
			gxHideOnNilValue:false,
			gxForePainter: "SilencePopupFore",
			gxMenuItems:
			[
				{	gxTitle: "Remove silence",		gxValue: 1 },
				{	gxTitle: "Start new file",		gxValue: 2 },
				{	gxTitle: "End recording",		gxValue: 3 }
			 ],
			gxValueKey: "node.silenceKiller.action",
			gxDisableOnKey: "node.silenceEditingDisabled",
			gxLabelText: "after:",
			axTitle: "Silence action",
		},
		silenceTime: {
			"+": "DarkNumberField",
			gxNilWhenEmpty: false,
			gxDecimalPlaces: 1,
			gxRangeMax: 99999,	// model will limit
			gxValueKey: "node.silenceKiller.time",
			gxDisableOnKey: "node.silenceEditingDisabled",
			gxLabelText: "seconds of silence",
			axTitle: "Silence time",
			axHelp: "Number of seconds of silence before action applies",
		},
		silenceThreshold : {
			"+": "SliderView",
			gxValueKey: "node.silenceKiller.threshold",
			gxDisableOnKey: "node.silenceEditingDisabled",
			gxRangeMin: -80,
			gxRangeMax: -10,
			gxDetents: "-60, -30",
			gxBaselineOffset: 16,
			gxDetentStrings: ["Digital", "Analog"],
			gxDetentLabelPainter: "SliderDetentLabelPainter",
			axFormatter: "DBFormatterWhole",
			gxLabelText: "Silence Threshold:",
			axTitle: "Silence Threshold Volume",
			axHelp: "Audio below this threshold is considered as silence. -60dB for digital, or -30dB for analog sources are suggested",
		},
		silenceReadout: {
			"+": "ReadoutView.left.baseline1",
			gxFormatter: "DBFormatterWhole",
			gxValueKey: "node.silenceKiller.threshold",
			gxIntrinsicHeight: 12
		}
	}
},
	
	
// -------------------------------------------------
// MARK: recorder token field

RecorderTokenField:
{
    "+": "TokenField",
    gxDisableOnKey: "running",
	axHelp: "Tokens can be added to this field from the context menu",
	
    // menu of tokens as displayed to user
    gxMenuItems:
    [
        {    gxTitle: "Session Name",        		gxValue: "%name" },
        {    gxTitle: "File Counter",        			gxValue: "%counter" },
		{    gxTitle: "Zero-Prefixed Counter",     gxValue: "%prefixed_counter" },
        {    gxTitle: "-" },
        {    gxTitle: "Date",                gxValue: "%date" },
        {    gxTitle: "Year",                gxValue: "%year" },
        {    gxTitle: "Month",            gxValue: "%month" },
        {    gxTitle: "Day",                gxValue: "%day" },
        {    gxTitle: "-" },
        {    gxTitle: "Time",                gxValue: "%time" },
        {    gxTitle: "Hour",                gxValue: "%hour" },
        {    gxTitle: "Minute",            gxValue: "%minute" },
        {    gxTitle: "Second",            gxValue: "%second" },
        {    gxTitle: "-" },
        {    gxTitle: "Title Tag",        gxValue: "%tag_title" },
        {    gxTitle: "Artist Tag",        gxValue: "%tag_artist" },
        {    gxTitle: "Album Tag",          gxValue: "%tag_album" },
        {    gxTitle: "Genre Tag",          gxValue: "%tag_genre" },
        {    gxTitle: "Comment Tag",        gxValue: "%tag_comment" },
        {    gxTitle: "Year Tag",            gxValue: "%tag_year" },
        {    gxTitle: "Track Tag",          gxValue: "%tag_track" },
        {    gxTitle: "Track Count Tag",    gxValue: "%tag_trackcount" },
        {    gxTitle: "Disc Tag",            gxValue: "%tag_disc" },
        {    gxTitle: "Disc Count Tag",    gxValue: "%tag_disccount" }
    ],
    // all allowable tokens, and the display names they use in cells
    gxTokenNames:
    {
        "%name":                "Session",
		"%counter":            "Counter",
        "%prefixed_counter":    "Prefixed Counter",
        "%index":            "Counter",    // AHP used %index for %counter, we allow it
        "%date":                "Date",
        "%year":                "Year",
        "%month":            "Month",
        "%day":                "Day",
        "%time":                "Time",
        "%hour":                "Hour",
        "%minute":            "Minute",
        "%second":            "Second",
        "%tag_title":        "Title",
        "%tag_artist":        "Artist",
        "%tag_album":        "Album",
        "%tag_genre":        "Genre",
        "%tag_comment":        "Comment",
        "%tag_year":            "Year",
        "%tag_track":        "Track",
        "%tag_trackcount":    "Track Count",
        "%tag_disc":            "Disc",
        "%tag_disccount":    "Disc Count"
    }
},


// -------------------------------------------------
// MARK: recorder bits

RecorderPauseSplitButton: {
	nsClass: "GXButtonView",
	gxBackPainter: {
		"+": "ControlBack",
		gxFillColor: "ColorTheme1",
		on: {
			gxFillColor: "ColorThemeLive1",
		},
	},
	gxForePainter: {
		"+": "LabelFore.withOn",
		gxFontColor: "LCDForeColor1.withOn",
		lightMode: {
			gxFontColor: "LCDForeColor1.withOn.noDisabled",
		},
	},
	gxButtonType: "checkbox",
	gxIntrinsicHeight: 25
},

RecorderPopupMenu: {
	"+": "PopupMenuTemplate",
	gxLayout: [ "H:[selfLabel]-[self]&alignBaseline",
				"H:|-130-[self]-32-|",
				"V:|-4-[self]" ]
},

SilencePopupFore: {
	"+": "PopupFore",
	gxEdgeInsets: "8,0,2,0"
},

DarkNumberField: {
	"+": "DarkTextField",
	nsClass: "GXNumberField",
	gxDecimalPlaces: 0,
	gxRangeMax: 999,
	gxNilWhenEmpty: true,	// be cautious of this. KVC to numeric property (rather than NSNumber) is bad.
	gxDisableOnNil: false
},

TimeOrSpacePopupMenu:
{
	"+": "PopupMenuTemplate",
	gxHideOnNilValue: false,
	gxMenuItems:
	[
		{	gxTitle: "Minutes",		gxValue: "time*60" },
		{	gxTitle: "Hours",			gxValue: "time*3600" },
		{	gxTitle: "-" },
		{	gxTitle: "Megabytes",		gxValue: "space*1" },
		{	gxTitle: "Gigabytes",		gxValue: "space*1024" }
	]
},

PresetFormatPopupMenu:
{
	"+": "PopupMenuTemplate",
	gxValueKey: "node.presetFormatID",
	gxDisableOnKey: "running",
	gxMenuItems:
	[
		{	gxTitle: "-For personal use" },
		{	gxTitle: ">Regular quality AAC",			gxValue: "AAC_128" },
		{	gxTitle: ">High quality AAC",				gxValue: "AAC_256" },
		{	gxTitle: "-For Internet distribution" },
		{	gxTitle: ">Regular quality MP3",			gxValue: "MP3_128" },
		{	gxTitle: ">High quality MP3",				gxValue: "MP3_256" },
		{	gxTitle: "-Perfect Quality" },
		{	gxTitle: ">Compressed Apple Lossless",	gxValue: "ALAC" },
		{	gxTitle: ">Uncompressed AIFF",			gxValue: "AIFF" },
		{	gxTitle: "-" },
		{	gxTitle: "Custom...",						gxValue: "" }
	]
},

GenrePopupMenu: {
	"+": "PopupMenuView.useMarkup",
	gxHideOnNilValue: false,
	gxDisableOnNil: false,
	gxMenuItems:
	[
		menuItem("<italic>None", null),		// null becomes NSNull in the menu then nil in the model
		menuDivider(),
		menuItem("Alternative", "Alternative"),
		menuItem("Blues/R&B", "Blues/R&B"),
		menuItem("Books & Spoken", "Books & Spoken"),
		menuItem("Children's Music", "Children's Music"),
		menuItem("Classical", "Classical"),
		menuItem("Country", "Country"),
		menuItem("Dance", "Dance"),
		menuItem("Easy Listening", "Easy Listening"),
		menuItem("Electronic", "Electronic"),
		menuItem("Folk", "Folk"),
		menuItem("Hip-Hop/Rap", "Hip-Hop/Rap"),
		menuItem("Holiday", "Holiday"),
		menuItem("House", "House"),
		menuItem("Industrial", "Industrial"),
		menuItem("Jazz", "Jazz"),
		menuItem("New Age", "New Age"),
		menuItem("Pop", "Pop"),
		menuItem("Religious", "Religious"),
		menuItem("Rock", "Rock"),
		menuItem("Soundtrack", "Soundtrack"),
		menuItem("Techno", "Techno"),
		menuItem("Trance", "Trance"),
		menuItem("Unclassifiable", "Unclassifiable"),
		menuItem("World", "World"),
	]
},



})
